﻿-- ■==============================================================================================■*/
--[[ !
    @file		ghost_highway_route_NAGASAKISATSUMA.lua
    @brief		全国街道チャレンジ ルート情報(長崎薩摩街道)
    @author		AutoGenerated (otsuka-y)
    @date		2019/10/11 16:12:50
--]]
-- ■==============================================================================================■*/
-- ルートファイルのID
ROUTE_ID = "NAGASAKISATSUMA"
-- ルート名
ROUTE_NAME = "長崎薩摩街道"

-- 門番・ボス分身を撃破することで入手可能な報酬
---- 記法
--   アイテムID, 報酬ID,
---- 報酬ID
--   どのマスの分身を倒した時にどの報酬を受け取るかを紐付ける(201-299)
RewardTable = {
	[CAT_STAMP] = {
		157,221,
		158,222,
		139,223,
	},
	[CAT_HONOR] = {
		630024,221,
		630025,222,
		630006,223,
	},

}

-- マス情報
---- 記法
-- マス種別, 関所とショートカット先ID, 報酬ID
----マス種別
--   SHOP,          //! 店舗マス
--   START,         //! スタートマス
--   MANUFARACTUER, //! メーカーマス
--   RECENT,        //! 最近プレイした相手マス
--   UNKNOWN,       //! ハテナマス
--   BONUS,         //! ボーナスマス
--   STATION,       //! 関所分身マス
--   BOSS,          //! ボス分身マス
--   BLANK,         //! 空白マス
---- 関所とショートカット先ID
-- 関所とショートカット先に対して同じIDを使用する (101-199)
---- 報酬ID
-- どのマスの分身を倒した時にどの報酬を受け取るかを紐付ける (201-299)
SquareTable = {
	START,
	RECENT,
	MANUFARACTUER,
	RECENT,
	SHOP,
	RECENT,
	BONUS,
	RECENT,
	SHOP,
	RECENT,
	BONUS,
	RECENT,
	UNKNOWN,
	STATION,	114,	221,
	SHOP,
	MANUFARACTUER,
	UNKNOWN,
	RECENT,	114,
	SHOP,
	RECENT,
	UNKNOWN,
	BONUS,
	RECENT,
	UNKNOWN,
	RECENT,
	UNKNOWN,
	BONUS,
	RECENT,
	UNKNOWN,
	RECENT,
	UNKNOWN,
	RECENT,
	STATION,	115,	222,
	UNKNOWN,
	MANUFARACTUER,
	RECENT,	115,
	SHOP,
	RECENT,
	RECENT,
	BOSS,	223,

}

-- 関所・ボス分身の情報テーブル
---- 記法
-- 車ID, 走行エリアID
---- 走行エリアID
--  Ａ１０１―３．分身・乱入・イベントモードのコースデータ→area IDに
-- 指定されている数値を指定 (0-17)
BarrierEmenyTable = {
	2025,
	2026,
	2007,13,

}

-- 双六マスインデント情報のテーブル(手動指定専用)
-- -- 記法
-- (通常ライン)          最初マスのインデント, 終了マスのインデント,
-- (ショートカットライン)最初マスのインデント, 終了マスのインデント,
-- 通常ライン
-- ショートカットライン
-- 通常ライン… これらをライン数分指定する
-- いずれのラインのインデントも設定しない場合はテーブル内は空欄でも可だが、
-- 1ラインでも指定する場合は、インデントしないラインは全て0で埋めること
LineIndentTable = {
	90,105,
	90,105,
	100,60,
	120,70,
	180,150,
	400,170,

}

-- 関所名リストテーブル
-- -- 記法
-- 関所名,
-- flashの関所名表示にのみ使用する
StationNameTable = {
	"Harada",
	"Noma",

}

function GetRewardTable ( category_id )
    return unpack( RewardTable[category_id] )
end

function GetSquareTable( )
    return unpack( SquareTable )
end

function GetBarrierEnemyTable( )
    return unpack( BarrierEmenyTable )
end

function GetRouteName()
    return ROUTE_NAME
end

function GetLineIndentTable()
    return unpack( LineIndentTable )
end

function LineIndentTableSize()
    return #LineIndentTable
end

function GetStationNameTable()
    return unpack( StationNameTable )
end

function GetStationNameTableSize()
    return #StationNameTable
end
